#ifndef _CUSTOMGUI_DATE_EDIT_H_
#define _CUSTOMGUI_DATE_EDIT_H_

#define DATETIME_GUI      1009383
#define DATETIME_DATA     1009398

#define DATETIME_TIME_CONTROL 'dttc'    // TRUE, if this is a clock
#define DATETIME_DATE_CONTROL 'dtdc'    // TRUE, if this is a calendar
#define DATETIME_COLUMN       'dtco'    // TRUE, if the calendar and the clock should be in one column
#define DATETIME_TIME_NOW     'dttn'    // TRUE, if the clock has a "now" button
#define DATETIME_DATE_TODAY   'dtdt'    // TRUE, if the calendar has a "today" button
#define DATETIME_CLOCK_OPEN   'dtcl'    // TRUE, if the clock is visible
#define DATETIME_CALENDAR_OPEN   'dtca'    // TRUE, if the calendar is open
#define DATETIME_COMPACT_MODE 'dtcm'    // TRUE, if you want a compact mode
#define DATETIME_COMPACT_OPEN 'dtco'    // TRUE, if the compact mode is open

#include "customgui_base.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_customdatatype.h"


struct tagDateTime
{
	tagDateTime() { lYear=2000; lMonth=lDay=1; lHour=lMinute=lSecond=0; }

  LONG lYear, lMonth, lDay;
  LONG lHour, lMinute, lSecond;

	Bool operator == (const tagDateTime &b) const;
	Bool operator != (const tagDateTime &b) const;
};

class DateTimeControl : public BaseCustomGui<DATETIME_GUI>
{
private:
		DateTimeControl();

	public:
    tagDateTime GetDateTime();
    void SetDateTime(tagDateTime *d, Bool bSetDate = TRUE, Bool bSetTime = TRUE);
};


class DateTimeData : public iCustomDataType<DateTimeData>
{
private:
  DateTimeData(void);

public:
  tagDateTime GetDateTime();
  void SetDateTime(tagDateTime *d, Bool bSetDate = TRUE, Bool bSetTime = TRUE);
};

// generates a modified the julian day. To get the correct Julian day,
// take the integer of this value and subtract .5
LReal GetJulianDay(tagDateTime &t);
tagDateTime FromJulianDay(LReal j);
void DateTimeNow(tagDateTime& t);

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#ifndef _DATETIMECONTROL_INTERNAL_DEF_
	class iDateTimeControl : public iBaseCustomGui
	{
	};
	class iDateTimeData
	{
	};
#else
	class iDateTimeControl;
	class iDateTimeData;
#endif

struct DateTimechooserLib : public BaseCustomGuiLib
{
	tagDateTime      (iDateTimeControl::*GetDateTimeGUI)();
	void             (iDateTimeControl::*SetDateTimeGUI)(tagDateTime *d, Bool bSetDate, Bool bSetTime);

	tagDateTime      (iDateTimeData::*GetDateTimeData)();
	void             (iDateTimeData::*SetDateTimeData)(tagDateTime *d, Bool bSetDate, Bool bSetTime);

  LReal             (*GetJulianDay)(tagDateTime &t);
  tagDateTime       (*FromJulianDay)(LReal j);
  void              (*DateTimeNow)(tagDateTime& t);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#endif // _CUSTOMGUI_DATE_EDIT_H_
